#!/bin/bash
sudo tee /etc/systemd/system/ptp4l.service << END
[Unit]
  Description=ptp4l service
  After=network.target
  StartLimitIntervalSec=0
[Service]
  Type=simple
  Restart=always
  RestartSec=1
  User=root
  ExecStart=/usr/sbin/ptp4l -2 -i enp177s0f0np0 -f /home/sempre/workspace/configs/linuxptp.conf -m
[Install]
  WantedBy=multi-user.target
END

sudo tee /etc/systemd/system/phc2sys.service << END
[Unit]
 Description=phc2sys service for ptp4l
 After=ptp4l.service
 StartLimitIntervalSec=0
[Service]
 Type=simple
 Restart=always
 RestartSec=1
 User=root
 ExecStart=/usr/sbin/phc2sys -s enp177s0f0np0 -w -m -R 8 -f /home/sempre/workspace/configs/linuxptp.conf

[Install]
 WantedBy=multi-user.target
END

sudo tee /etc/systemd/system/ts2phc.service << END
[Unit]
  Description=ts2phc service
  After=network.target
  StartLimitIntervalSec=0
[Service]
  Type=simple
  Restart=always
  RestartSec=1
  User=root
  ExecStart=/usr/sbin/ts2phc -f /home/sempre/workspace/configs/ts2phc-gm.cfg -s nmea -m -c enp177s0f0np0
[Install]
  WantedBy=multi-user.target
END

sudo systemctl enable ptp4l.service ts2phc.service ts2phc.service
sudo systemctl start ptp4l.service ts2phc.service ts2phc.service
sudo systemctl status ptp4l.service ts2phc.service ts2phc.service
