#!/bin/bash
#
# Copyright 2021-2025 Software Radio Systems Limited
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the distribution.
#
. /usr/lib/tuned/functions

start() {
  # srsRAN Performance Script
  echo N | tee /sys/module/drm_kms_helper/parameters/poll >/dev/null
  echo performance | tee /sys/devices/system/cpu/cpu*/cpufreq/scaling_governor >/dev/null

  # Set systemd user.slice and system.slice
  systemctl set-property system.slice AllowedCPUs=0,12
  systemctl set-property user.slice AllowedCPUs=0,12

  # Create cgroup for isolated cores
  mkdir -p /sys/fs/cgroup/gnb/
  echo 0 > /sys/fs/cgroup/gnb/cpuset.mems
  echo "1-11,13-23" > /sys/fs/cgroup/gnb/cpuset.cpus

  # VF creation and DPDK bindings
  echo 1 > /sys/class/net/enp81s0f0np0/device/sriov_numvfs
  ip link set enp81s0f0np0 vf 0 mac 00:33:22:33:00:11 spoofchk off
  dpdk-devbind.py --bind=vfio-pci 0000:01:01.0

  # NIC tuning
  sleep 30
  ethtool -A enp81s0f1np1 rx on tx on
  ethtool -G enp81s0f1np1 rx 8160 tx 2048
  tc qdisc replace dev enp81s0f1np1 root fq flow_limit 100000 quantum 1514 buckets 4096 orphan_mask 1023
  ip link set dev enp81s0f1np1 txqueuelen 10000
  ethtool -K enp81s0f1np1 tso on gso on gro on lro off rxvlan on txvlan on
  ethtool -G enp81s0f1np1 rx 8160 tx 2048   # (or rx 4096 tx 2048 if you prefer)
  ethtool -C enp81s0f1np1 adaptive-rx off adaptive-tx off rx-usecs 16 tx-usecs 16

  return "$?"
}

stop() {
  return "$?"
}

process $@
